//MECH 2 BROADCASTS 

//----------------------------------------------------

schema mc2a0sn			//SLEEPING
archetype AI_NONE
volume -500
mono_loop 2000 3000
mc2a0sn1 mc2a0sn2 mc2a0sn3 mc2a0sn4 mc2a0sn5 
schema_voice vmech2 1 sleeping

schema mc2a0			//COUGHING
archetype AI_NONE
delay 3000
volume -500
mono_loop 7500 15000
mc2a0co1 mc2a0co2 mc2a0co3 mc2a0co4 mc2a0co5 mc2a0co6 
mc2a0th1 mc2a0th2 mc2a0th3 mc2a0th4 mc2a0th5 mc2a0th6
schema_voice vmech2 1 atlevelzero

schema mc2a0hu			//HUMMING & WHISTLING
archetype AI_NONE
delay 3000
stream
volume -500
mono_loop 7500 15000
mc2a0hu1 mc2a0hu2 mc2a0hu3 mc2a0hu4 mc2a0hu5 mc2a0hu6
mc2a0wh1 mc2a0wh2 mc2a0wh3 mc2a0wh4 mc2a0wh5 
mc2a0co1 mc2a0co2 mc2a0co3
schema_voice vmech2 2 atlevelzero

schema mc2a0ch			//CHANTING & MUTTERING
archetype AI_NONE
delay 3000
volume -500
mono_loop 7500 15000
mc2a0ch1 mc2a0ch2 mc2a0ch3 mc2a0ch4 mc2a0ch5 mc2a0ch6
mc2a0th1 mc2a0th2 mc2a0th3 mc2a0th4 mc2a0th5 mc2a0th6
schema_voice vmech2 3 atlevelzero

//----------------------------------------------------

schema mc2a1			//TO ALERT 1
archetype AI_NONE
mc2a1__1 mc2a1__2 mc2a1__3 mc2a1__4 
schema_voice vmech2 1 tolevelone  

schema mc2a1v			//TO ALERT 1 +sighted
archetype AI_NONE
mc2a1v_1
schema_voice vmech2 1 tolevelone (Sense Sight)

schema mc2a1h			//TO ALERT 1 +heard
archetype AI_NONE
mc2a1h_1 mc2a1h_2
schema_voice vmech2 2 tolevelone (Sense Sound)

schema mc2a1_w			//TO ALERT 1 +w/co
archetype AI_MINOR
mc2a1_w1
schema_voice vmech2 2 tolevelone (NearbyFriends 0 20)

schema mc2a1vw			//TO ALERT 1 +sighted +w/co
archetype AI_MINOR
mc2a1vw1 mc2a1vw2 mc2a1vw3
schema_voice vmech2 3 tolevelone (Sense Sight) (NearbyFriends 0 20)

schema mc2a1hw			//TO ALERT 1 +heard +w/co
archetype AI_MINOR
mc2a1hw1 mc2a1hw2 mc2a1hw3
schema_voice vmech2 3 tolevelone (Sense Sound) (NearbyFriends 0 20)


//----------------------------------------------------

schema mc2a2			//TO ALERT 2
archetype AI_MINOR
mc2a2__1 mc2a2__2 mc2a2__3 mc2a2__4
schema_voice vmech2 1 toleveltwo  

schema mc2a2v			//TO ALERT 2 +sighted
archetype AI_MINOR
mc2a2v_1
schema_voice vmech2 1 toleveltwo (Sense Sight)  

schema mc2a2h			//TO ALERT 2 +heard
archetype AI_MINOR
mc2a2h_1 mc2a2h_2
schema_voice vmech2 2 toleveltwo (Sense Sound)

//----------------------------------------------------

schema mc2a3 			//TO ALERT 3 NOT BY SEEING THE PLAYER
archetype AI_MAJOR
mc2a3__1 mc2a3__2 mc2sec_1
schema_voice vmech2 1 tolevelthree

schema mc2a3s			//SPOTTED THE PLAYER
archetype AI_MORE_MAJOR
mc2a3s_1 mc2a3s_2 mc2a3s_3 
mc2a3na1 mc2a3na2 mc2a3na3 
schema_voice vmech2 1 spotplayer 

schema mc2telr			//SPOTTED THE PLAYER +w/co
archetype AI_COMBAT
mc2telr1 mc2telr2 mc2telr3 mc2telr4
schema_voice vmech2 5 spotplayer (NearbyFriends 0 20)
schema_voice vmech2 1 reacttellrev

schema mc2a3b			//SPOTTED THE PLAYER +body
archetype AI_MORE_MAJOR
mc2a3b_1 mc2a3b_2 
schema_voice vmech2 9 spotplayer (CarryBody True)

schema mc2telc			//RE-SPOTTED THE PLAYER +w/co
archetype AI_COMBAT
mc2telc1 mc2telc2 mc2telc3
schema_voice vmech2 5 spotplayer (NearbyFriends 0 20) (Reacquire true)
schema_voice vmech2 1 reacttellconf

//----------------------------------------------------

schema mc2at1			//AT ALERT 1 & 2
archetype AI_NONE
delay 3000
volume -500
mono_loop 7500 15000
mc2a0co1 mc2a0co2 mc2a0co3 mc2a0co4 mc2a0co5 mc2a0co6 
mc2a0th1 mc2a0th2 mc2a0th3 mc2a0th4 mc2a0th5 mc2a0th6
schema_voice vmech2 1 atlevelone
schema_voice vmech2 1 atleveltwo

schema mc2at2			//AT ALERT 2 & 3 +Investigating
archetype AI_MINOR
delay 6000
mono_loop 15000 30000
no_repeat
mc2a2se1 mc2a2se2 mc2a2se3 mc2a2se4 mc2a3se1 mc2a3se2 mc2a3se3 mc2a3se4
schema_voice vmech2 99 atleveltwo (Investigate True)
schema_voice vmech2 99 atlevelthree (Investigate True)

//----------------------------------------------------

schema mc2chga			//REACT CHARGE
archetype AI_MORE_MAJOR
mc2chga1 mc2chga2 mc2chga3 mc2chga4
schema_voice vmech2 1 reactcharge

schema mc2chgw			//REACT CHARGE +w/co
archetype AI_COMBAT
mc2chgw1 mc2chgw2 mc2chgw3
schema_voice vmech2 2 reactcharge (NearbyFriends 0 20)

schema mc2atb			//REACT SHOOT	
archetype AI_MORE_MAJOR
mc2atb_1 mc2atb_2 mc2atb_3
mc2ats_1 mc2ats_2 mc2ats_3
schema_voice vmech2 1 reactshoot

schema mc2runa			//REACT RUN AWAY +alone
archetype AI_MAJOR
mc2runa1 mc2runa2 mc2runa3
schema_voice vmech2 1 reactrun 

schema mc2alma			//REACT I SOUND THE ALARMS
archetype AI_MORE_MAJOR
mc2alma1 mc2alma2 mc2alma3
schema_voice vmech2 1 reactalarm

schema mc2almw			//REACT YOU TO SOUND THE ALARMS +w/co
archetype AI_COMBAT
mc2almw1
schema_voice vmech2 9 reactalarm (NearbyFriends 0 20)

//----------------------------------------------------

schema mc2bak			//BACK TO ALERT 0
archetype AI_NONE
volume -500
mc2bak_1 mc2bak_2 mc2bak_3 mc2bak_4 mc2bak_5 mc2bak_6 
schema_voice vmech2 1 backtozero  

schema mc2los			//LOST CONTACT W/PLAYER
archetype AI_NONE
mc2los_1 mc2los_2 mc2los_3
schema_voice vmech2 1 lostcontact  

schema mc2frust			//FRUSTRATION
archetype AI_MAJOR
mc2frus1 mc2frus2 mc2frus3
schema_voice vmech2 1 outofreach 

schema mc2torch			//NOTICED A DOUSED TORCH
archetype AI_MINOR
delay 1000
mc2torc1 mc2torc2
schema_voice vmech2 1 notice (Item GasLight Torch)

schema mc2getbowman		//RUN & GET A BOWMAN
archetype AI_MORE_MAJOR
mc2runa1 mc2runa2
schema_voice vmech2 1 getbowman 

//----------------------------------------------------

schema mc2bod			//FOUND BODY	
archetype AI_MORE_MAJOR
mc2bod_1 mc2bod_2 mc2bod_3
schema_voice vmech2 1 foundbody  

schema mc2mis			//FOUND SOMETHING MISSING
archetype AI_MAJOR
mc2mis_1 mc2mis_2
schema_voice vmech2 1 foundmissing
schema_voice vmech2 1 notice (Item MissingLoot)

schema mc2sma			//FOUND A SMALL ANOMALY
archetype AI_MINOR
mc2sma_1 mc2sma_2
schema_voice vmech2 1 foundsmall  
schema_voice vmech2 1 notice (Item Door Generic)

schema mc2lar			//FOUND A LARGE ANOMALY
archetype AI_MAJOR
mc2lar_1 mc2lar_2
schema_voice vmech2 1 foundlarge

schema mc2sec			//FOUND A SECURITY BREACH
archetype AI_MORE_MAJOR
mc2sec_1 mc2sec_2 mc2sec_3
schema_voice vmech2 1 foundbreach

schema mc2rob			//FOUND DEAD ROBOT	
archetype AI_MAJOR
mc2rob_1 mc2rob_2 mc2rob_3
schema_voice vmech2 1 foundrobot  

//----------------------------------------------------

schema mc2rint			//RECENTLY SAW THE PLAYER +w/co
archetype AI_INFORM
mc2rint1 mc2rint2 mc2rint3
schema_voice vmech2 1 recentintruder 

schema mc2rbod			//RECENTLY FOUND BODY +w/co
archetype AI_INFORM
mc2rbod1 mc2rbod2
schema_voice vmech2 1 recentbody 

schema mc2rmis			//RECENTLY FOUND MISSING +w/co
archetype AI_INFORM
mc2rmis2 
schema_voice vmech2 1 recentmissing 

schema mc2roth			//RECENTLY FOUND MISC ANAMOLY +w/co
archetype AI_INFORM
mc2roth1 mc2roth2 mc2roth3
schema_voice vmech2 1 recentother 

schema mc2rrob			//RECENTLY FOUND DEAD ROBOT +w/co
archetype AI_INFORM
mc2rrob1
schema_voice vmech2 1 recentrobot 

//----------------------------------------------------

//COMBAT
schema mc2atn			//ATTACKING +not losing
archetype AI_COMBAT
mc2atn_1 freq 1
mc2atn_2 freq 1
mc2atn_3 freq 2
mc2atn_4 freq 2
mc2atn_5 freq 2
mc2atn_6 freq 1
mc2atn_7 freq 1
mc2atn_8 freq 1
mc2atn_9 freq 1
mc2atn_a freq 1
mc2atn_b freq 2
mc2atn_c freq 2
mc2atn_d freq 2
schema_voice vmech2 1 comattack (ComBal Winning Even)

schema mc2atnw			//ATTACKING +winning
archetype AI_COMBAT
mc2atw_1 mc2atw_2
schema_voice vmech2 2 comattack (ComBal Winning)

schema mc2atww			//ATTACKING +winning +w/co
archetype AI_COMBAT
mc2atww1
schema_voice vmech2 2 comattack (ComBal Winning) (NearbyFriends 0 20)

schema mc2atl			//ATTACKING +losing
archetype AI_COMBAT
mc2atl_1 mc2atl_2 mc2atl_3 mc2atl_4 mc2atl_5 mc2atl_6 mc2atl_7 mc2atl_8 
schema_voice vmech2 1 comattack (ComBal Losing)

//----------------------------------------------------

schema mc2hit			//HIT THE PLAYER
archetype AI_COMBAT
mc2hit_1 mc2hit_2 mc2hit_3 mc2hit_4
schema_voice vmech2 1 comsucchit (ComBal Winning Even)

schema mc2hitw			//HIT THE PLAYER +w/co
archetype AI_COMBAT
mc2hitw1 mc2hitw2
schema_voice vmech2 2 comsucchit (ComBal Winning Even) (NearbyFriends 0 20)

schema mc2blk			//BLOCKED THE PLAYER
archetype AI_COMBAT
mc2blk_1 mc2blk_2 mc2blk_3
schema_voice vmech2 1 comsuccblock (ComBal Winning Even)

schema mc2blkw			//BLOCKED THE PLAYER +w/co
archetype AI_COMBAT
mc2blkw1
schema_voice vmech2 2 comsuccblock (ComBal Winning Even) (NearbyFriends 0 20)

//----------------------------------------------------

schema mc2hhi			//HIT BY PLAYER W/HI HIT PTS 
archetype AI_MAJOR
mc2hhi_1 mc2hhi_2 mc2hhi_3 mc2hhi_4 mc2hhi_5
mc2hlo_1 mc2hlo_2 mc2hlo_3 mc2hlo_4
mc2hhi_1 mc2hhi_2 mc2hhi_3 mc2hhi_4 mc2hhi_5 
schema_voice vmech2 1 comhithigh
schema_voice vmech2 99 comhitnodam (ComBal Losing)

schema mc2hlo			//HIT BY PLAYER W/LO PTS 
archetype AI_MORE_MAJOR
mc2hlo_1 mc2hlo_2 mc2hlo_3 mc2hlo_4 
schema_voice vmech2 1 comhitlow

schema mc2hlow			//HIT BY PLAYER W/LO PTS  +w/co
archetype AI_COMBAT
mc2hlow1
schema_voice vmech2 1 comhitlow (NearbyFriends 0 20)

schema mc2hnd			//HIT BY PLAYER NO DAMAGE +Winning
archetype AI_MAJOR
mc2hnd_1 mc2hnd_2 mc2hnd_3
schema_voice vmech2 1 comhitnodam (ComBal Winning)
schema_voice vmech2 1 comhitnodam 

schema mc2hnde			//HIT BY PLAYER NO DAMAGE +Even
archetype AI_MAJOR
mc2hnde1 mc2hnde2 mc2hnde3
schema_voice vmech2 99 comhitnodam (ComBal Even)
schema_voice vmech2 3 comhitnodam 

//----------------------------------------------------

schema mc2bkd 			//BLOCKED BY PLAYER
archetype AI_COMBAT
mc2bkd_1 mc2bkd_2 mc2bkd_3
schema_voice vmech2 1 comblocked (ComBal Winning Even)

schema mc2bkdw 			//BLOCKED BY THE PLAYER +w/co
archetype AI_COMBAT
mc2bkdw1
schema_voice vmech2 2 comblocked (ComBal Winning Even) (NearbyFriends 0 20)

schema mc2det 			//DETECTED BLOCK
archetype AI_COMBAT
mc2det_1 mc2det_2 mc2det_3
schema_voice vmech2 1 comdetblock (ComBal Winning Even)

schema mc2detw 			//DETECTED BLOCK +w/co
archetype AI_COMBAT
mc2detw1
schema_voice vmech2 2 comdetblock (ComBal Winning Even) (NearbyFriends 0 20)

//----------------------------------------------------

schema mc2amb 		//AMBUSHED
archetype AI_MAJOR 
mc2amb_1 mc2amb_2 mc2amb_3 mc2amb_4
schema_voice vmech2 1 comhitamb

schema mc2ambw		//AMBUSHED +w/co
archetype AI_COMBAT
mc2ambw1 mc2ambw2 mc2ambw3
schema_voice vmech2 2 comhitamb (NearbyFriends 0 20)

schema mc2diea		//SOFT DEATH
archetype AI_MINOR
volume -500
mc2diea1 mc2diea2 mc2diea3 mc2diea4 mc2diea5
schema_voice vmech2 1 comdiesoft

schema mc2diec		//LOUD DEATH
archetype AI_COMBAT
mc2diec1 mc2diec2 mc2diec3 mc2diec4 mc2diec5 
schema_voice vmech2 1 comdieloud

//----------------------------------------------------
//----------------------------------------------------

//HAMMER 1 BROADCASTS -Stephen Russell

//AT ALERT 0 MORE REPEATABLE
schema mhm1a0
archetype AI_NONE
stream
volume -500
mono_loop 7500 10000
hm1a0co1 hm1a0co2 hm1a0co3
hm1a0hu1 hm1a0hu2 hm1a0hu3 hm1a0hu4
hm1a0th1 hm1a0th2 hm1a0th3
hm1a0wh1 hm1a0wh2 hm1a0wh3
schema_voice vmech5 3 atlevelzero

//AT ALERT 0 LESS REPEATABLE
schema mhm1a0ch
archetype AI_NONE
volume -500
mono_loop 7500 10000
hm1a0ch1 hm1a0ch2 hm1a0ch3
schema_voice vmech5 1 atlevelzero
schema_voice vmech5 1 atlevelone

//AT ALERT 0 ASLEEP
schema mhm1a0sn
archetype AI_NONE
volume -500
mono_loop 2000 3000
hm1a0sn1 hm1a0sn2 hm1a0sn3
schema_voice vmech5 1 sleeping

//TO ALERT 1
schema mhm1a1
archetype AI_NONE
hm1a1__1 hm1a1__2 hm1a1__3 hm1a1__4 
schema_voice vmech5 1 tolevelone  

//TO ALERT 1 +sighted
schema mhm1a1v
archetype AI_NONE
hm1a1v_1
schema_voice vmech5 1 tolevelone (Sense Sight)

//TO ALERT 1 +heard
schema mhm1a1h
archetype AI_NONE
hm1a1h_1 hm1a1h_2
schema_voice vmech5 2 tolevelone (Sense Sound)

//TO ALERT 1 +w/co
schema mhm1a1_w
archetype AI_MINOR
hm1a1_w1
schema_voice vmech5 2 tolevelone (NearbyFriends 0 20)

//TO ALERT 1 +sighted +w/co
schema mhm1a1vw
archetype AI_MINOR
hm1a1vw1 hm1a1vw2 hm1a1vw3
schema_voice vmech5 3 tolevelone (Sense Sight) (NearbyFriends 0 20)

//TO ALERT 1 +heard +w/co
schema mhm1a1hw
archetype AI_MINOR
hm1a1hw1 hm1a1hw2 hm1a1hw3
schema_voice vmech5 3 tolevelone (Sense Sound) (NearbyFriends 0 20)

//TO ALERT 2
schema mhm1a2
archetype AI_MINOR
hm1a2__1 hm1a2__2 hm1a2__3 hm1a2__4
schema_voice vmech5 1 toleveltwo  

//TO ALERT 2 +sighted
schema mhm1a2v
archetype AI_MINOR
hm1a2v_1
schema_voice vmech5 1 toleveltwo (Sense Sight)  

//TO ALERT 2 +heard
schema mhm1a2h
archetype AI_MINOR
hm1a2h_1 hm1a2h_2
schema_voice vmech5 2 toleveltwo (Sense Sound)

//TO ALERT 3
schema mhm1a3
archetype AI_MAJOR
Hm1a3s_3
schema_voice vmech5 1 tolevelthree


//AT ALERT 3
schema mhm1at3inv
archetype AI_MAJOR
delay 3000
no_repeat
mono_loop 10000 30000
hm1a2se1 hm1a2se2 hm1a2se3 hm1a2se4 hm1a3se1 hm1a3se2 hm1a3se3 hm1a3se4
schema_voice vmech5 99 atleveltwo (Investigate True)
schema_voice vmech5 99 atlevelthree (Investigate True)

//SPOTTED THE PLAYER +startled
schema mhm1a3s
archetype AI_MORE_MAJOR
hm1a3s_1 hm1a3s_2 hm1a3s_3
schema_voice vmech5 1 spotplayer 

//SPOTTED THE PLAYER +not startled +alone
schema mhm1a3na
archetype AI_MORE_MAJOR
hm1a3na1 hm1a3na2 hm1a3na3 hm1a3na4
schema_voice vmech5 1 spotplayer

//SPOTTED THE PLAYER +carrying a body
schema mhm1a3b
archetype AI_MORE_MAJOR
hm1a3b_1 hm1a3b_2 
schema_voice vmech5 9 spotplayer (CarryBody True)

//REACT CHARGE +alone
schema mhm1chga
archetype AI_MORE_MAJOR
hm1chga1 hm1chga2 hm1chga3 hm1chga4
schema_voice vmech5 1 reactcharge

//REACT CHARGE +w/co
schema mhm1chgw
archetype AI_COMBAT
hm1chgw1 hm1chgw2 hm1chgw3
schema_voice vmech5 2 reactcharge (NearbyFriends 0 20)

//REACT RUN AWAY +alone
schema mhm1runa
archetype AI_MAJOR
hm1runa1 hm1runa2 hm1runa3
schema_voice vmech5 1 reactrun

//REACT I SOUND THE ALARMS +alone
schema mhm1alma
archetype AI_MORE_MAJOR
hm1alma1 hm1alma2
schema_voice vmech5 1 reactalarm

//REACT I TELL YOU TO SOUND THE ALARMS +w/co
schema mhm1almw
archetype AI_COMBAT
hm1almw1
schema_voice vmech5 5 reactalarm (NearbyFriends 0 20)

//REACT TELL FRIEND BY REVELATION +w/co
schema mhm1telr
archetype AI_COMBAT
hm1telr1 hm1telr2 hm1telr3
schema_voice vmech5 5 spotplayer (NearbyFriends 0 20)

//REACT TELL FRIEND BY CONFIRMATION +w/co
schema mhm1telc
archetype AI_COMBAT
hm1telc1 hm1telc2 hm1telc3
schema_voice vmech5 5 spotplayer (NearbyFriends 0 20) (Reacquire true)

//BACK TO ALERT 0
schema mhm1bak
archetype AI_NONE
hm1bak_1 hm1bak_2 hm1bak_3 hm1bak_4
hm1bak_5 hm1bak_6 hm1bak_7 hm1bak_8
schema_voice vmech5 1 backtozero  

//LOST CONTACT W/PLAYER
schema mhm1los
archetype AI_NONE
hm1los_1 hm1los_2 hm1los_3
schema_voice vmech5 1 lostcontact  

//FRUSTRATION
schema mhm1frust
archetype AI_MAJOR
Hm1a3se2 Hm1det_2 Hm1det_1 Hm1bkd_1
schema_voice vmech5 1 outofreach  

//FOUND BODY
schema mhm1bod
archetype AI_MORE_MAJOR
hm1bod_1 hm1bod_2 hm1bod_3
schema_voice vmech5 1 foundbody  

//FOUND SOMETHING MISSING
schema mhm1mis
archetype AI_MAJOR
hm1mis_1 hm1mis_2
schema_voice vmech5 1 foundmissing

//NOTICED A TORCH BEING DOUSED
schema mhm1torch
archetype AI_MINOR
delay 1000
Hm1bak_6
schema_voice vmech5 1 notice (item torch gaslight) 


//FOUND A SMALL ANOMALY
schema mhm1sma
archetype AI_MINOR
hm1sma_1 hm1sma_2
schema_voice vmech5 1 foundsmall  

//FOUND A LARGE ANOMALY
schema mhm1lar
archetype AI_MAJOR
hm1lar_1 hm1lar_2
schema_voice vmech5 1 foundlarge

//FOUND A SECURITY BREACH
schema mhm1sec
archetype AI_MORE_MAJOR
hm1sec_1 hm1sec_2 hm1sec_3
schema_voice vmech5 1 foundbreach

//RECENTLY SAW THE PLAYER +w/co
schema mhm1rint
archetype AI_INFORM
hm1rint1 hm1rint2 hm1rint3
schema_voice vmech5 1 recentintruder 

//RECENTLY FOUND BODY +w/co
schema mhm1rbod
archetype AI_INFORM
hm1rbod1 hm1rbod2
schema_voice vmech5 1 recentbody 

//RECENTLY FOUND SOMETHING MISSING +w/co
schema mhm1rmis
archetype AI_INFORM
hm1rmis1 
schema_voice vmech5 1 recentmissing 

//RECENTLY FOUND MISC ANAMOLY +w/co
schema mhm1roth
archetype AI_INFORM
hm1roth1 hm1roth2 hm1roth3
schema_voice vmech5 1 recentother 

//COMBAT

//ATTACKING +not losing
schema mhm1atn
archetype AI_COMBAT
hm1atn_1 freq 1
hm1atn_2 freq 1
hm1atn_3 freq 5
hm1atn_4 freq 5
hm1atn_5 freq 5
hm1atn_6 freq 1
hm1atn_7 freq 1
hm1atn_8 freq 1
hm1atn_9 freq 1
hm1atn_A freq 3
schema_voice vmech5 1 comattack (ComBal Winning Even)

//ATTACKING +winning
schema mhm1atnw
archetype AI_COMBAT
hm1atw_1 hm1atw_2
schema_voice vmech5 3 comattack (ComBal Winning)

//ATTACKING +winning +w/co
schema mhm1atww
archetype AI_COMBAT
hm1atww1
schema_voice vmech5 3 comattack (ComBal Winning) (NearbyFriends 0 20)

//ATTACKING +losing
schema mhm1atl
archetype AI_COMBAT
hm1atl_1 hm1atl_2 hm1atl_3 hm1atl_4 hm1atl_5 hm1atl_6 
schema_voice vmech5 1 comattack (ComBal Losing)

//SUCCESSFULLY HIT THE PLAYER +not losing
schema mhm1hit
archetype AI_COMBAT
hm1hit_1 hm1hit_2 hm1hit_3 hm1hit_4
schema_voice vmech5 1 comsucchit (ComBal Winning Even)

//SUCCESSFULLY HIT THE PLAYER +not losing +w/co
schema mhm1hitw
archetype AI_COMBAT
hm1hitw1 hm1hitw2
schema_voice vmech5 2 comsucchit (ComBal Winning Even) (NearbyFriends 0 20)

//SUCCESSFULLY BLOCKED THE PLAYER +not losing
schema mhm1blk
archetype AI_COMBAT
hm1blk_1 hm1blk_2 hm1blk_3
schema_voice vmech5 1 comsuccblock (ComBal Winning Even)

//SUCCESSFULLY BLOCKED THE PLAYER +not losing +w/co
schema mhm1blkw
archetype AI_COMBAT
hm1blkw1
schema_voice vmech5 2 comsuccblock (ComBal Winning Even) (NearbyFriends 0 20)

//HIT BY THE PLAYER W/HI HIT PTS 
schema mhm1hhi
archetype AI_MAJOR
hm1hhi_1 hm1hhi_2 hm1hhi_3
schema_voice vmech5 1 comhithigh
schema_voice vmech5 9 comhitnodam (ComBal Losing)

//HIT BY THE PLAYER W/LO PTS 
schema mhm1hlo
archetype AI_MORE_MAJOR
hm1hlo_1 freq 1
hm1hlo_2 freq 2
hm1hlo_3 freq 2
hm1hlo_4 freq 2
hm1hlo_5 freq 1
schema_voice vmech5 1 comhitlow

//HIT BY THE PLAYER W/LO PTS  +w/co
schema mhm1hlow
archetype AI_COMBAT
hm1hlow1
schema_voice vmech5 1 comhitlow (NearbyFriends 0 20)

//HIT BY THE PLAYER NO DAMAGE
schema mhm1hnd
archetype AI_MAJOR
hm1hnd_1 hm1hnd_2 hm1hnd_3
schema_voice vmech5 9 comhitnodam (ComBal Winning)
schema_voice vmech5 1 comhitnodam

//HIT BY THE PLAYER NO DAMAGE EVEN
schema mhm1hnde
archetype AI_MAJOR
hm1hnde1 hm1hnde2 hm1hnde3
schema_voice vmech5 9 comhitnodam (ComBal Even)
schema_voice vmech5 1 comhitnodam

//BLOCKED BY THE PLAYER +not losing
schema mhm1bkd 
archetype AI_COMBAT
hm1bkd_1 hm1bkd_2 hm1bkd_3
schema_voice vmech5 1 comblocked (ComBal Winning Even)

//BLOCKED BY THE PLAYER +not losing +w/co
schema mhm1bkdw 
archetype AI_COMBAT
hm1bkdw1
schema_voice vmech5 2 comblocked (ComBal Winning Even) (NearbyFriends 0 20)

//DETECTED PLAYER TRYING TO BLOCK +not losing
schema mhm1det 
archetype AI_COMBAT
hm1det_1 hm1det_2 hm1det_3
schema_voice vmech5 1 comdetblock (ComBal Winning Even)

//DETECTED PLAYER TRYING TO BLOCK +w/co
schema mhm1dets
archetype AI_COMBAT
hm1detw1
schema_voice vmech5 1 comdetblock (ComBal Winning Even) (NearbyFriends 0 20)

//AMBUSHED -HIT BY UNSEEN PLAYER
schema mhm1amb 
archetype AI_MAJOR
hm1amb_1 hm1amb_2 hm1amb_3 hm1amb_4
schema_voice vmech5 1 comhitamb

//AMBUSHED -HIT BY UNSEEN PLAYER +w/co
schema mhm1ambw
archetype AI_COMBAT
hm1ambw1 hm1ambw2 hm1ambw3
schema_voice vmech5 2 comhitamb (NearbyFriends 0 20)

//DEATH BY COMBAT -LOUD
schema mhm1diec
archetype AI_COMBAT
hm1diec1 hm1diec2 hm1diec3
schema_voice vmech5 1 comdieloud

//DEATH (or knocked out)BY AMBUSH -MORE MUFFLED
schema mhm1diea
archetype AI_MINOR
volume -1000
hm1diea1 hm1diea2 hm1diea3
schema_voice vmech5 1 comdiesoft







//HAMMER 2 BROADCASTS -Geoff Stewart

//SLEEPING
schema mhm2a0sn
archetype AI_NONE
volume -500
mono_loop 2000 3000
hm2a0sn1 hm2a0sn2 hm2a0sn3
schema_voice vmech6 1 sleeping

//AT ALERT 0 MORE REPEATABLE
schema mhm2a0
archetype AI_NONE
volume -500
mono_loop 7500 10000
hm2a0co1 hm2a0co2 hm2a0co3
hm2a0hu1 hm2a0hu2 hm2a0hu3
hm2a0th1 hm2a0th2 hm2a0th3
hm2a0wh1 hm2a0wh2 hm2a0wh3
schema_voice vmech6 3 atlevelzero

//AT ALERT 0 LESS REPEATABLE
schema mhm2a0ch
archetype AI_NONE
volume -1000
mono_loop 7500 10000
hm2a0ch1 hm2a0ch2 hm2a0ch3
hm2a0mu1 hm2a0mu2 hm2a0mu3
schema_voice vmech6 1 atlevelzero

//TO ALERT 1
schema mhm2a1
archetype AI_NONE
hm2a1__1 hm2a1__2 hm2a1__3 hm2a1__4 
schema_voice vmech6 1 tolevelone  

//TO ALERT 1 +sighted
schema mhm2a1v
archetype AI_NONE
hm2a1v_1
schema_voice vmech6 1 tolevelone (Sense Sight)

//TO ALERT 1 +heard
schema mhm2a1h
archetype AI_NONE
hm2a1h_1 hm2a1h_2
schema_voice vmech6 2 tolevelone (Sense Sound)

//TO ALERT 1 +w/co
schema mhm2a1_w
archetype AI_MINOR
hm2a1_w1
schema_voice vmech6 2 tolevelone (NearbyFriends 0 20)

//TO ALERT 1 +sighted +w/co
schema mhm2a1vw
archetype AI_MINOR
hm2a1vw1 hm2a1vw2 hm2a1vw3
schema_voice vmech6 3 tolevelone (Sense Sight) (NearbyFriends 0 20)

//TO ALERT 1 +heard +w/co
schema mhm2a1hw
archetype AI_MINOR
hm2a1hw1 hm2a1hw2 hm2a1hw3
schema_voice vmech6 3 tolevelone (Sense Sound) (NearbyFriends 0 20)

//TO ALERT 2
schema mhm2a2
archetype AI_MINOR
hm2a2__1 hm2a2__2 hm2a2__3 hm2a2__4
schema_voice vmech6 1 toleveltwo  

//TO ALERT 2 +sighted
schema mhm2a2v
archetype AI_MINOR
hm2a2v_1
schema_voice vmech6 1 toleveltwo (Sense Sight)  

//TO ALERT 2 +heard
schema mhm2a2h
archetype AI_MINOR
hm2a2h_1 hm2a2h_2
schema_voice vmech6 2 toleveltwo (Sense Sound)

//TO ALERT 3
schema mhm2a3
archetype AI_MAJOR
Hm2a3na3
schema_voice vmech6 1 tolevelthree

//AT ALERT 1
schema mhm2at1
archetype AI_NONE
delay 5000
mono_loop 5000 10000
Hm2a0ch1 Hm2a0ch3 Hm2a0ch3
schema_voice vmech6 1 atlevelone

//AT ALERT 2
schema mhm2at2
archetype AI_MINOR
delay 4500
no_repeat
mono_loop 10000 30000
hm2a2se1 hm2a2se2 hm2a2se3 hm2a2se4
schema_voice vmech6 99 atleveltwo (Investigate True)

//AT ALERT 3
schema mhm2at3
archetype AI_MAJOR
delay 4500
no_repeat
mono_loop 15000 30000
hm2a3se1 hm2a3se2 hm2a3se3 hm2a3se4
schema_voice vmech6 99 atlevelthree (Investigate True)

//SPOTTED THE PLAYER +startled
schema mhm2a3s
archetype AI_MORE_MAJOR
hm2a3s_1 hm2a3s_2 hm2a3s_3 
schema_voice vmech6 1 spotplayer 

//SPOTTED THE PLAYER +not startled +alone
schema mhm2a3na
archetype AI_MORE_MAJOR
hm2a3na1 hm2a3na2 hm2a3na3 
schema_voice vmech6 1 spotplayer 

//SPOTTED THE PLAYER +carrying a body
schema mhm2a3b
archetype AI_MORE_MAJOR
hm2a3b_1 hm2a3b_2 
schema_voice vmech6 9 spotplayer (CarryBody True)

//REACT CHARGE +alone
schema mhm2chga
archetype AI_MORE_MAJOR
hm2chga1 hm2chga2 
schema_voice vmech6 1 reactcharge

//REACT CHARGE +w/co
schema mhm2chgw
archetype AI_COMBAT
hm2chgw1 hm2chgw2 hm2chgw3
schema_voice vmech6 2 reactcharge (NearbyFriends 0 20)

//REACT RUN AWAY +alone
schema mhm2runa
archetype AI_MAJOR
hm2runa1 hm2runa2 hm2runa3
schema_voice vmech6 1 reactrun

//REACT I SOUND THE ALARMS +alone
schema mhm2alma
archetype AI_MORE_MAJOR
hm2alma1 hm2alma2 hm2alma3
schema_voice vmech6 1 reactalarm 

//REACT I TELL YOU TO SOUND THE ALARMS +w/co
schema mhm2almw
archetype AI_COMBAT
hm2almw1
schema_voice vmech6 9 reactalarm (NearbyFriends 0 20)

//REACT TELL FRIEND BY REVELATION +w/co
schema mhm2telr
archetype AI_COMBAT
hm2telr1 hm2telr2 hm2telr3 hm2telr4
schema_voice vmech6 5 spotplayer (NearbyFriends 0 20)

//REACT TELL FRIEND BY CONFIRMATION +w/co
schema mhm2telc
archetype AI_COMBAT
hm2telc1 hm2telc2 hm2telc3
schema_voice vmech6 5 spotplayer (NearbyFriends 0 20) (Reacquire true)

//BACK TO ALERT 0
schema mhm2bak
archetype AI_NONE
hm2bak_1 hm2bak_2 hm2bak_3 hm2bak_4
hm2bak_5 hm2bak_6 
schema_voice vmech6 1 backtozero  

//LOST CONTACT W/PLAYER
schema mhm2los
archetype AI_NONE
hm2los_1 hm2los_2 hm2los_3
schema_voice vmech6 1 lostcontact  

//FRUSTRATION
schema mhm2frust
archetype AI_MAJOR
hm2a3se2 hm2amb_3 hm2bkd_1 hm2bkd_2
schema_voice vmech6 1 outofreach  

//FOUND BODY
schema mhm2bod
archetype AI_MORE_MAJOR
hm2bod_1 hm2bod_2 hm2bod_3
schema_voice vmech6 1 foundbody  

//FOUND SOMETHING MISSING
schema mhm2mis
archetype AI_MAJOR
hm2mis_1 hm2mis_2
schema_voice vmech6 1 foundmissing

//NOTICED A TORCH BEING DOUSED
schema mhm2torch
archetype AI_MINOR
delay 1000
Hm2a1__4 Hm2a1__2
schema_voice vmech6 1 noticetorch

//FOUND A SMALL ANOMALY
schema mhm2sma
archetype AI_MAJOR
hm2sma_1 hm2sma_2
schema_voice vmech6 1 foundsmall  

//FOUND A LARGE ANOMALY
schema mhm2lar
archetype AI_MAJOR
hm2lar_1 hm2lar_2
schema_voice vmech6 1 foundlarge

//FOUND A SECURITY BREACH
schema mhm2sec
archetype AI_MORE_MAJOR
hm2sec_1 hm2sec_2 hm2sec_3
schema_voice vmech6 1 foundbreach

//RECENTLY SAW THE PLAYER +w/co
schema mhm2rint
archetype AI_INFORM
hm2rint1 hm2rint2 hm2rint3
schema_voice vmech6 1 recentintruder 

//RECENTLY FOUND BODY +w/co
schema mhm2rbod
archetype AI_INFORM
hm2rbod1 hm2rbod2 
schema_voice vmech6 1 recentbody 

//RECENTLY FOUND SOMETHING MISSING +w/co
schema mhm2rmis
archetype AI_INFORM
hm2rmis2 
schema_voice vmech6 1 recentmissing 

//RECENTLY FOUND MISC ANAMOLY +w/co
schema mhm2roth
archetype AI_INFORM
hm2roth1 hm2roth2 hm2roth3
schema_voice vmech6 1 recentother 

//COMBAT

//ATTACKING +not losing
schema mhm2atn
archetype AI_COMBAT
hm2atn_1 freq 1
hm2atn_2 freq 1
hm2atn_3 freq 6
hm2atn_4 freq 6
hm2atn_5 freq 6
hm2atn_6 freq 1
hm2atn_7 freq 1
hm2atn_8 freq 1
hm2atn_9 freq 1
schema_voice vmech6 1 comattack (ComBal Winning Even)

//ATTACKING +winning
schema mhm2atnw
archetype AI_COMBAT
hm2atw_1 hm2atw_1
schema_voice vmech6 3 comattack (ComBal Winning)

//ATTACKING +winning +w/co
schema mhm2atww
archetype AI_COMBAT
hm2atww1 
schema_voice vmech6 4 comattack (ComBal Winning) (NearbyFriends 0 20)

//ATTACKING +losing
schema mhm2atl
archetype AI_COMBAT
hm2atl_1 freq 1
hm2atl_2 freq 1
hm2atl_3 freq 2
hm2atl_4 freq 2
hm2atl_5 freq 2
schema_voice vmech6 1 comattack (ComBal Losing)

//SUCCESSFULLY HIT THE PLAYER +not losing
schema mhm2hit
archetype AI_COMBAT
hm2hit_1 hm2hit_2 hm2hit_3 hm2hit_4
schema_voice vmech6 1 comsucchit (ComBal Winning Even)

//SUCCESSFULLY HIT THE PLAYER +not losing +w/co
schema mhm2hit
archetype AI_COMBAT
hm2hitw1 hm2hitw2
schema_voice vmech6 2 comsucchit (ComBal Winning Even) (NearbyFriends 0 20)

//SUCCESSFULLY BLOCKED THE PLAYER +not losing
schema mhm2blk
archetype AI_COMBAT
hm2blk_1 hm2blk_2 hm2blk_3
schema_voice vmech6 1 comsuccblock (ComBal Winning Even)

//SUCCESSFULLY BLOCKED THE PLAYER +not losing +w/co
schema mhm2blkw
archetype AI_COMBAT
hm2blkw1
schema_voice vmech6 2 comsuccblock (ComBal Winning Even) (NearbyFriends 0 20)

//HIT BY THE PLAYER W/HI HIT PTS 
schema mhm2hhi
archetype AI_MAJOR
hm2hhi_1 hm2hhi_2 hm2hhi_3
schema_voice vmech6 1 comhithigh

//HIT BY THE PLAYER W/LO PTS 
schema mhm2hlo
archetype AI_MORE_MAJOR
hm2hlo_1 freq 1
hm2hlo_2 freq 2
hm2hlo_3 freq 2
hm2hlo_4 freq 2
schema_voice vmech6 1 comhitlow

//HIT BY THE PLAYER W/LO PTS  +w/co
schema mhm2hlow
archetype AI_COMBAT
hm2hlow1 freq 1
hm2hlo_1 freq 2
hm2hlo_2 freq 2
schema_voice vmech6 2 comhitlow (NearbyFriends 0 20)

//HIT BY THE PLAYER NO DAMAGE
schema mhm2hnd
archetype AI_MAJOR
hm2hnd_1 hm2hnd_2 hm2hnd_3
schema_voice vmech6 1 comhitnodam

//BLOCKED BY THE PLAYER +not losing
schema mhm2bkd 
archetype AI_COMBAT
hm2bkd_1 hm2bkd_2 hm2bkd_3
schema_voice vmech6 1 comblocked (ComBal Winning Even)

//BLOCKED BY THE PLAYER +not losing +w/co
schema mhm2bkdw 
archetype AI_COMBAT
hm2bkdw1
schema_voice vmech6 2 comblocked (ComBal Winning Even) (NearbyFriends 0 20)

//DETECTED PLAYER TRYING TO BLOCK +not losing
schema mhm2det 
archetype AI_COMBAT
hm2det_1 hm2det_2 hm2det_3
schema_voice vmech6 1 comdetblock(ComBal Winning Even)

//DETECTED PLAYER TRYING TO BLOCK +not losing +w/co
schema mhm2detw 
archetype AI_COMBAT
hm2detw1
schema_voice vmech6 2 comdetblock (ComBal Winning Even) (NearbyFriends 0 20)

//AMBUSHED -HIT BY UNSEEN PLAYER
schema mhm2amb 
archetype AI_MAJOR
hm2amb_1 hm2amb_2 hm2amb_3 hm2amb_4
schema_voice vmech6 1 comhitamb

//AMBUSHED -HIT BY UNSEEN PLAYER +w/co
schema mhm2ambw
archetype AI_COMBAT
hm2ambw1 hm2ambw2 hm2ambw3
schema_voice vmech6 2 comhitamb (NearbyFriends 0 20)

//DEATH BY COMBAT -LOUD
schema mhm2diec
archetype AI_COMBAT
hm2diec1 hm2diec2 hm2diec3
schema_voice vmech6 1 comdieloud

//DEATH (or knocked out)BY AMBUSH -MORE MUFFLED
schema mhm2diea
archetype AI_MINOR
hm2diea1 hm2diea2 hm2diea3
schema_voice vmech6 1 comdiesoft

//HAMMER 3 BROADCASTS -Joffrey Spaulding

//SLEEPING
schema mhm3a0sn
archetype AI_NONE
volume -500
mono_loop 2000 3000
hm3a0sn1 hm3a0sn2 hm3a0sn3
schema_voice vmech7 1 sleeping

//AT ALERT 0 MORE REPEATABLE
schema mhm3a0
archetype AI_NONE
volume -500
mono_loop 7500 15000
hm3a0co1 hm3a0co2 hm3a0co3
hm3a0hu1 hm3a0hu2 hm3a0hu3
hm3a0th1 hm3a0th2 hm3a0th3
hm3a0wh1 hm3a0wh2 hm3a0wh3
schema_voice vmech7 2 atlevelzero

//AT ALERT 0 LESS REPEATABLE
schema mhm3a0ch
archetype AI_NONE
volume -1000
mono_loop 7500 15000
hm3a0ch1 hm3a0ch2 hm3a0ch3
hm3a0mu1 hm3a0mu2 hm3a0mu3
schema_voice vmech7 1 atlevelzero

//TO ALERT 1
schema mhm3a1
archetype AI_NONE
hm3a1__1 hm3a1__2 hm3a1__3 hm3a1__4 
schema_voice vmech7 1 tolevelone  

//TO ALERT 1 +sighted
schema mhm3a1v
archetype AI_NONE
hm3a1v_1
schema_voice vmech7 1 tolevelone (Sense Sight)

//TO ALERT 1 +heard
schema mhm3a1h
archetype AI_NONE
hm3a1h_1 
schema_voice vmech7 2 tolevelone (Sense Sound)

//TO ALERT 1 +w/co
schema mhm3a1_w
archetype AI_MINOR
hm3a1_w1
schema_voice vmech7 2 tolevelone (NearbyFriends 0 20)

//TO ALERT 1 +sighted +w/co
schema mhm3a1vw
archetype AI_MINOR
hm3a1vw1 hm3a1vw2 hm3a1vw3
schema_voice vmech7 3 tolevelone (Sense Sight) (NearbyFriends 0 20)

//TO ALERT 1 +heard +w/co
schema mhm3a1hw
archetype AI_MINOR
hm3a1hw1 hm3a1hw2 hm3a1hw3
schema_voice vmech7 3 tolevelone (Sense Sound) (NearbyFriends 0 20)

//TO ALERT 2
schema mhm3a2
archetype AI_MINOR
hm3a2__1 hm3a2__2 hm3a2__3 hm3a2__4
schema_voice vmech7 1 toleveltwo  

//TO ALERT 2 +sighted
schema mhm3a2v
archetype AI_MINOR
hm3a2v_1
schema_voice vmech7 1 toleveltwo (Sense Sight)  

//TO ALERT 2 +heard
schema mhm3a2h
archetype AI_MINOR
hm3a2h_1 
schema_voice vmech7 2 toleveltwo (Sense Sound)

//TO ALERT 3
schema mhm3a3
archetype AI_MAJOR
Hm3a3na1 Hm3a3na2
schema_voice vmech7 1 tolevelthree

//AT ALERT 2
schema mhm3at2
archetype AI_MINOR
delay 6000
mono_loop 15000 30000
no_repeat
hm3a2se1 hm3a2se2 hm3a2se3 hm3a2se4
schema_voice vmech7 99 atleveltwo (Investigate True)

//AT ALERT 3
schema mhm3at3
archetype AI_MAJOR
delay 6000
mono_loop 15000 30000
no_repeat
hm3a3se1 hm3a3se2 hm3a3se3 hm3a3se4
schema_voice vmech7 99 atlevelthree (Investigate True)

//SPOTTED THE PLAYER +startled
schema mhm3a3s
archetype AI_MORE_MAJOR
hm3a3s_1 hm3a3s_2 hm3a3s_3 
schema_voice vmech7 1 spotplayer 

//SPOTTED THE PLAYER +not startled +alone
schema mhm3a3na
archetype AI_MORE_MAJOR
hm3a3na1 hm3a3na2  
schema_voice vmech7 1 spotplayer

//SPOTTED THE PLAYER +carrying a body
schema mhm3a3b
archetype AI_MORE_MAJOR
hm3a3b_1 hm3a3b_2 
schema_voice vmech7 9 spotplayer (CarryBody True)

//REACT CHARGE +alone
schema mhm3chga
archetype AI_MORE_MAJOR
hm3chga1 hm3chga2 hm3chga3 hm3chga4 hm3chga5
schema_voice vmech7 1 reactcharge

//REACT CHARGE +w/co
schema mhm3chgw
archetype AI_COMBAT
hm3chgw1 hm3chgw2 hm3chgw3
schema_voice vmech7 2 reactcharge (NearbyFriends 0 20)

//REACT RUN AWAY +alone
schema mhm3runa
archetype AI_MAJOR
hm3runa1 hm3runa2 hm3runa3
schema_voice vmech7 1 reactrun 

//REACT I SOUND THE ALARMS +alone
schema mhm3alma
archetype AI_MORE_MAJOR
hm3alma1 hm3alma2 
schema_voice vmech7 1 reactalarm

//REACT I TELL YOU TO SOUND THE ALARMS +w/co
schema mhm3almw
archetype AI_COMBAT
hm3almw1
schema_voice vmech7 9 reactalarm (NearbyFriends 0 20)

//REACT TELL FRIEND BY REVELATION +w/co
schema mhm3telr
archetype AI_COMBAT
hm3telr1 hm3telr2 hm3telr3 
schema_voice vmech7 5 spotplayer (NearbyFriends 0 20)

//REACT TELL FRIEND BY CONFIRMATION +w/co
schema mhm3telc
archetype AI_COMBAT
hm3telc1 hm3telc2 hm3telc3
schema_voice vmech7 5 spotplayer (NearbyFriends 0 20) (Reacquire true)

//BACK TO ALERT 0
schema mhm3bak
archetype AI_NONE
hm3bak_1 hm3bak_2 hm3bak_3 hm3bak_4
hm3bak_5 hm3bak_6 hm3bak_7
schema_voice vmech7 1 backtozero  

//LOST CONTACT W/PLAYER
schema mhm3los
archetype AI_NONE
hm3los_1 hm3los_2 hm3los_3
schema_voice vmech7 1 lostcontact  

//FRUSTRATION
schema mhm3frust
archetype AI_MAJOR
Hm3blk_1 Hm3det_1 Hm3bkd_3
schema_voice vmech7 1 outofreach  



//FOUND BODY
schema mhm3bod
archetype AI_MORE_MAJOR
hm3bod_1 hm3bod_2 hm3bod_3
schema_voice vmech7 1 foundbody  

//FOUND SOMETHING MISSING
schema mhm3mis
archetype AI_MAJOR
hm3mis_1 
schema_voice vmech7 1 foundmissing

//NOTICED A TORCH BEING DOUSED
schema mhm3torch
archetype AI_MINOR
delay 1000
Hm3a1__1 Hm3a1__2 Hm3a1__3 Hm3a1__4 Hm3bak_4 Hm3bak_6
schema_voice vmech7 1 noticetorch

//FOUND A SMALL ANOMALY
schema mhm3sma
archetype AI_MINOR
hm3sma_1 hm3sma_2
schema_voice vmech7 1 foundsmall  

//FOUND A LARGE ANOMALY
schema mhm3lar
archetype AI_MAJOR
hm3lar_1 hm3lar_2
schema_voice vmech7 1 foundlarge

//FOUND A SECURITY BREACH
schema mhm3sec
archetype AI_MORE_MAJOR
hm3sec_1 hm3sec_2 hm3sec_3
schema_voice vmech7 1 foundbreach

//RECENTLY SAW THE PLAYER +w/co
schema mhm3rint
archetype AI_INFORM
hm3rint1 
schema_voice vmech7 1 recentintruder 

//RECENTLY FOUND BODY +w/co
schema mhm3rbod
archetype AI_INFORM
hm3rbod1  
schema_voice vmech7 1 recentbody 

//RECENTLY FOUND SOMETHING MISSING +w/co
schema mhm3rmis
archetype AI_INFORM
hm3rmis3 
schema_voice vmech7 1 recentmissing 

//RECENTLY FOUND MISC ANAMOLY +w/co
schema mhm3roth
archetype AI_INFORM
hm3roth1 hm3roth2 hm3roth3
schema_voice vmech7 1 recentother 

//COMBAT

//ATTACKING +not losing
schema mhm3atn
archetype AI_COMBAT
hm3atn_1 freq 1
hm3atn_2 freq 1
hm3atn_3 freq 6
hm3atn_4 freq 6
hm3atn_5 freq 6
hm3atn_6 freq 1
hm3atn_7 freq 1
hm3atn_8 freq 1
schema_voice vmech7 1 comattack (ComBal Winning Even)

//ATTACKING +winning
schema mhm3atnw
archetype AI_COMBAT
hm3atw_1 hm3atw_2
schema_voice vmech7 3 comattack (ComBal Winning)

//ATTACKING +winning +w/co
schema mhm3atww
archetype AI_COMBAT
hm3atww1 
schema_voice vmech7 4 comattack (ComBal Winning) (NearbyFriends 0 20)

//ATTACKING +losing
schema mhm3atl
archetype AI_COMBAT
hm3atl_1 freq 1
hm3atl_2 freq 1
hm3atl_3 freq 2
hm3atl_4 freq 2
hm3atl_5 freq 2
hm3atl_6 freq 2
schema_voice vmech7 1 comattack (ComBal Losing)

//SUCCESSFULLY HIT THE PLAYER +not losing
schema mhm3hit
archetype AI_COMBAT
hm3hit_1 hm3hit_2 hm3hit_3 hm3hit_4
schema_voice vmech7 1 comsucchit (ComBal Winning Even)

//SUCCESSFULLY HIT THE PLAYER +not losing +w/co
schema mhm3hit
archetype AI_COMBAT
hm3hitw1 hm3hitw2
schema_voice vmech7 2 comsucchit (ComBal Winning Even) (NearbyFriends 0 20)

//SUCCESSFULLY BLOCKED THE PLAYER +not losing
schema mhm3blk
archetype AI_COMBAT
hm3blk_1 hm3blk_2 hm3blk_3
schema_voice vmech7 1 comsuccblock (ComBal Winning Even)

//SUCCESSFULLY BLOCKED THE PLAYER +not losing +w/co
schema mhm3blkw
archetype AI_COMBAT
hm3blkw1
schema_voice vmech7 2 comsuccblock (ComBal Winning Even) (NearbyFriends 0 20)

//HIT BY THE PLAYER W/HI HIT PTS 
schema mhm3hhi
archetype AI_MAJOR
hm3hhi_1 hm3hhi_2 hm3hhi_3
schema_voice vmech7 1 comhithigh

//HIT BY THE PLAYER W/LO PTS 
schema mhm3hlo
archetype AI_MORE_MAJOR
hm3hlo_1 freq 1
hm3hlo_2 freq 2
hm3hlo_3 freq 2
hm3hlo_4 freq 2
schema_voice vmech7 1 comhitlow

//HIT BY THE PLAYER W/LO PTS  +w/co
schema mhm3hlow
archetype AI_COMBAT
hm3hlow1
schema_voice vmech7 1 comhitlow (NearbyFriends 0 20)

//HIT BY THE PLAYER NO DAMAGE
schema mhm3hnd
archetype AI_MAJOR
hm3hnd_1 hm3hnd_2 hm3hnd_3
schema_voice vmech7 1 comhitnodam

//BLOCKED BY THE PLAYER +not losing
schema mhm3bkd 
archetype AI_COMBAT
hm3bkd_1 hm3bkd_2 hm3bkd_3
schema_voice vmech7 1 comblocked (ComBal Winning Even)

//BLOCKED BY THE PLAYER +not losing +w/co
schema mhm3bkdw 
archetype AI_COMBAT
hm3bkdw1
schema_voice vmech7 2 comblocked (ComBal Winning Even) (NearbyFriends 0 20)

//DETECTED PLAYER TRYING TO BLOCK +not losing
schema mhm3det 
archetype AI_COMBAT
hm3det_1 hm3det_2 hm3det_3
schema_voice vmech7 1 comdetblock(ComBal Winning Even)

//DETECTED PLAYER TRYING TO BLOCK +not losing +w/co
schema mhm3detw 
archetype AI_COMBAT
hm3detw1
schema_voice vmech7 2 comdetblock (ComBal Winning Even) (NearbyFriends 0 20)

//AMBUSHED -HIT BY UNSEEN PLAYER
schema mhm3amb 
archetype AI_MAJOR 
hm3amb_1 hm3amb_2 hm3amb_3 hm3amb_4
schema_voice vmech7 1 comhitamb

//AMBUSHED -HIT BY UNSEEN PLAYER +w/co
schema mhm3ambw
archetype AI_COMBAT
hm3ambw1 hm3ambw2 hm3ambw3
schema_voice vmech7 2 comhitamb (NearbyFriends 0 20)

//DEATH BY COMBAT -LOUD
schema mhm3diec
archetype AI_COMBAT
hm3diec1 hm3diec2 hm3diec3
schema_voice vmech7 1 comdieloud

//DEATH (or knocked out)BY AMBUSH -MORE MUFFLED
schema mhm3diea
archetype AI_MINOR
volume -1000
hm3diea1 hm3diea2 hm3diea3
schema_voice vmech7 1 comdiesoft
