// A KEEPER OF THE PROPHECIES
// CUSTOM AUDIO SCHEMAS EPISODE 5 THROUGH 9

// Edited 8/11/2004 - removed pan range factor from pile driver audio.
// Edited 8/18/2004 - added misc ambients section.

// Compiled, stolen, recorded, or otherwise acquired or mangled by frobber.
// Archetype here is BOOK2SND under the SOUND > FROBBER schema hierarchy.

// Other audio being used in these episodes from other missions...
// -- All town clock chimes from Hallucinations and Insurrection.
// -- Distant thunder from the Enterprise.
// -- Ocean and "baby" sounds from the Enterprise.
// -- Ambient "asteroid" wind from Oracle of the Prophets.
// -- Portal start, run, and shutdown from the Insurrection.
// -- Rain from the Enterprise.
// -- Interior air ventalation sounds from the Enterprise.
// -- Rain heard from the interior -- from the Enterprise.

/////////////////////////////
//// BASIC MISSION SOUND ////
/////////////////////////////

schema ora_astro_ld // Louder than Oracle of the Prophets
archetype ORA_SND
poly_loop 2 0 0
no_repeat
volume -1200 // was 2400
ora_astro1 ora_astro2 ora_astro3

////////////////////////
/// MISSION STARTUPS ///
////////////////////////

// Startup sound -- The Other Side of Time - DONE
// Starship through-the stars at "high-warp-speed" sound
schema time_arrive
archetype BOOK2SND
volume -300
time_arrive

// Startup sound -- Reversing the Order - PLACEHOLDER
// Probably nothing -- left here as a potential hook
schema rev_arrive
archetype BOOK2SND
volume -400
rev_arrive

// Startup sound -- Moving Day - DONE (left @ 44KHz)
// Garrett narration VO here by SlyFoxx
schema move_arrive
archetype BOOK2SND
volume -400
move_arrive

// Startup sound -- Under the Raven Moon - DONE (left @ 44KHz)
// This is a camvator mission
// Audio VO is the whole track
schema raven_arrive
archetype BOOK2SND
volume -400
raven_arrive


////////////////////////////
/// END OF MISSION AUDIO ///
////////////////////////////

// Plays at the end of The Inheritance during the final camvator - DONE
schema inher_leave
archetype BOOK2SND
volume -1
inher_leave


/////////////////////
/// CONVERSATIONS ///
/////////////////////

// (by Lizanneh and SlyFoxx)
// Alisha and Garrett have a talk
// Not used (see file broken into three parts for better sych with AI motions)
// schema inher_alish_gar
// archetype BOOK2SND
// volume -500
// inher_alish_gar

// (by Lizanneh and SlyFoxx)
// Alisha and Garrett have a talk - Part A
schema inh_lishgara
archetype BOOK2SND
delay 2500
volume -300
inh_lishgara

// (by Lizanneh and SlyFoxx)
// Alisha and Garrett have a talk - Part B
schema inh_lishgarb
archetype BOOK2SND
volume -300
inh_lishgarb

// (by Lizanneh and SlyFoxx)
// Alisha and Garrett have a talk - Part C
schema inh_lishgarc
archetype BOOK2SND
volume -300
inh_lishgarc

// (by Lizanneh and SlyFoxx)
// Alisha speaks with Franticius - DONE
schema rev_alisha_fran
archetype BOOK2SND
volume -500
rev_alisha_fran

// (by Lizanneh and Saturnine) - DONE (left @ 44KHz)
// Alish speaks with Cavador
schema rev_alisha_cav
archetype BOOK2SND
volume -300 
rev_alisha_cav


//////////////////
/// MONOLOGUES ///
//////////////////

// Karras grumbles in his lab in the cathedral - DONE
schema time_karras1
archetype BOOK2SND
volume -400 
time_karras1


// (by Msledd) - DONE
// Kevel's wife berates him should Garrett take a short cut home.
// This will be similar to the version in Hallucinations but not as long.
schema rev_missie
archetype BOOK2SND 
delay 2000
volume -1000
rev_missie


///////////////////////////
//// BIRDS AND PEEPERS ////
///////////////////////////

// Cardinals, Grossbeaks and other related birds
schema bk2_cardinal
archetype BOOK2SND
poly_loop 2 30000 35000
no_repeat
volume -800
cardinal1 cardinal2 cardinal3 cardinal4 cardinal5 cardinal6 cardinal7 cardinal8 cardinal9

// Wrens from around North America
schema bk2_wren
archetype BOOK2SND
poly_loop 2 30000 35000
no_repeat
volume -800
wren1234 wren5 wren6 wren7 wren8 wren9 wren10 wren11

// Thrushes
schema bk2_thrush
archetype BOOK2SND
poly_loop 2 22000 32000
no_repeat
volume -800
thrush1 thrush2

// Warblers
schema bk2_warbler
archetype BOOK2SND
poly_loop 2 16000 24000
no_repeat
volume -800
warbler123 warbler4

// Miscellaneous birds -- finch, red wing blackbird, catbird
schema bk2_birds_misc
archetype BOOK2SND
poly_loop 2 4000 6000
no_repeat
volume -800
finch1 rwblkbird1 rwblkbird2 rwblkbird3 rwblkbird4 
catbird1 catbird2 catbird3 catbird4 

// Peepers (baby frogs -- not birds) in stereo
schema bk2_peepers
archetype BOOK2SND
mono_loop 0 0
volume -1000
peepers1

// Peepers Softer in stereo
schema bk2_peepers_sof
archetype BOOK2SND
mono_loop 0 0
volume -1500
peepers1


///////////////////
///// THUNDER /////
///////////////////

// Ongoing distant thunder loop - First used in The Enterprise ver 2
schema thunder_dist
archetype ENT_SND
poly_loop 2 160000 320000
pan_range 1000 // as of 1-15-05 (was 3000)
volume -800
no_repeat
thundist1 thundist2 thundist3

// Distant thunder NO loop -- louder than in the Enterprise
schema bk2_thunder
archetype BOOK2SND
no_repeat
pan_range 1000
volume -1
thundist1 thundist2 thundist3

// Really Close Thunder, no delay 
// thundnear6.wav not good enough to use - deleted
schema bk2_thundnear0
archetype BOOK2SND
no_repeat
delay 0
volume -1
thundnear7 thundnear1 thundnear4 thundnear5 thundnear3 thundnear2 thundnear8

// Sorta Nearby Thunder, delay 1/2 second 
// thundnear6.wav not good enough to use - deleted
schema bk2_thundnear500
archetype BOOK2SND
no_repeat
delay 2000
volume -400
thundnear2 thundnear8 thundnear4 thundnear5 thundnear7 thundnear3 thundnear1

// Not as Close Thunder, delay 1 second
// thundnear6.wav not good enough to use - deleted
schema bk2_thundnear1000
archetype BOOK2SND
no_repeat
delay 4000
volume -800
thundnear1 thundnear2 thundnear3 thundnear4 thundnear5 thundnear7 thundnear8


//////////////////////////////
////// Cathedral Interior ////
//////////////////////////////

// Cathedral Interior1 (processed to 11KHz to speed loadup -- yuck!)
schema bk2_cathedral1
archetype BOOK2SND
mono_loop 0 0
volume -1
bk2_cathedral1

// Cathedral Interior2 (processed to 11KHz to speed loadup -- yuck!)
schema bk2_cathedral2
archetype BOOK2SND
mono_loop 0 0
volume -1
bk2_cathedral2


///////////////////////////
///// OTHER AMBIENTS //////
///////////////////////////

//////////////
//// RAIN ////
//////////////

// RAIN STEREO - same audio in both channels @ different times

// Rain loop, made from Thief 2 rain hack files
schema rain_gen_st
archetype ENT_SND
mono_loop 0 0
volume -600
rain_gen_st

// Rain loop near buildings
schema rain_gen2_st
archetype ENT_SND
mono_loop 0 0
volume -800
rain_gen2_st

// Raining on grass and small leaves
schema rain_grass_st
archetype ENT_SND
mono_loop 0 0
volume -800
rain_grass_st

// Raining hard on open pavement
schema rain_stone_st
archetype ENT_SND
mono_loop 0 0
volume -800
rain_stone_st

// RAIN CONVERTED TO STEREO - (was mono - also deleted pan_range)

// Rain loop, single wav file made from Thief 2 wav hack files
schema rain_gen
archetype ENT_SND
mono_loop 0 0
volume -600 // was -550 mono
rain_gen_st

// Rain loop similar to Thief 2 hacks
schema rain_gen2
archetype ENT_SND
mono_loop 0 0
volume -800 // was -550 mono
rain_gen2_st

// Raining on grass and small leaves
schema rain_grass
archetype ENT_SND
mono_loop 0 0
volume -800 // was -100 mono (way too loud)
rain_grass_st

// Raining hard on open pavement
schema rain_stone
archetype ENT_SND
mono_loop 0 0
volume -800 // was -500 mono
rain_stone_st

// Raining on stone - soft - Used around Cathedral in the TOSoT
schema rain_stone_soft
archetype ENT_SND
mono_loop 0 0
volume -2000
rain_stone_st

// RAIN MONO

// Rain splashing near building
schema rain_spout
archetype ENT_SND
mono_loop 0 0
pan_range 1000
volume -800
rain_spout

// Raining on metal roof
schema rain_metal
archetype ENT_SND
mono_loop 0 0
// pan_range 1000
volume -300
rain_metal

// Raining on wood roof 
schema rain_roof
archetype ENT_SND
mono_loop 0 0
// pan_range 1000
volume -300
rain_roof

// Raining on wood roof as heard from ceiling indoors
schema rain_ceiling
archetype ENT_SND
mono_loop 0 0
// pan_range 1000
volume -800
rain_ceiling

// Raining on metal roof as heard from ceiling indoors
schema rain_ceiling2
archetype ENT_SND
mono_loop 0 0
// pan_range 1000
volume -1000
rain_ceiling2


// Pile Drivers

// Pile-driver loop - somewhat far away - DONE
schema bk2_piledr_near
archetype BOOK2SND
mono_loop 0 0
volume -600
bk2_piledriver

// Distant pile-driver loop - very far away - DONE
schema bk2_piledr_far
archetype BOOK2SND
mono_loop 0 0
volume -2000
bk2_piledriver

// Miscelleneous Sounds

// Pencil scratching sounds of someone writing quickly - DONE
schema raven_pencil
archetype BOOK2SND
volume -250
raven_pencil

// Tavern Chatter
schema bk2_tavchat
archetype BOOK2SND
no_repeat
mono_loop 0 0 // One of these wavs is randomly looped continuosly.
volume -600
tavchat1 tavchat2 tavchat3

// Lisha deploys her daggers
schema rev_dagger_snd
archetype BOOK2SND
volume -300
rev_dagger_snd


//////////////////////////
////// FRANTICIOUS ///////
//////////////////////////

// Franticius intructs his men regarding Alisha "follow me..." - DONE
schema rev_fran1
archetype BOOK2SND
volume -1
rev_fran1


// Franticius intructs his men to chase Alisha "After her!!" - DONE
schema rev_fran2
archetype BOOK2SND
volume -100
rev_fran2


// "Guards!"
schema rev_franny3
archetype BOOK2SND
delay 250
no_repeat
frna3__2 frna3__3 frna3__4


///////////////////////////
/// FRIENDLY HAMMERITES ///
///////////////////////////

// Random greetings - ALL three hammerite voices
schema hamgreetings
archetype BOOK2SND
no_repeat
hm1m2301 hm2m2301 hm3m2301 hm1m2302 hm2m2302 hm3m2302 hm1m2303
hm2m2303 hm3m2303 hm3m2304 hm3m2305

// Random - "Raise the gate!"
schema raisethegate
archetype BOOK2SND
no_repeat
hm1m2320 hm2m2320 hm3m2320


////////////////////////////////////////////
//// GARRETT VOICE OVERS ///////////////////
//// by Scott Murchison a.k.a., SlyFoxx ////
////////////////////////////////////////////


///////// THE OTHE SIDE OF TIME -- Garrett VOs ////////////

// "Looks like the Guardian sent me back to the cathedral..."
schema time_gar1
archetype BOOK2SND
volume -300 // louder to speak over sound of the portal
time_gar1

// "Since when do they bother to heat this building in the winter?"
schema time_gar2
archetype BOOK2SND
volume -400
time_gar2

// "Hmmm... the last time I was here, there was ice on that river..."
schema time_gar3
archetype BOOK2SND
volume -400
delay 1500
time_gar3

// "I thought they got rid of that lunatic."
schema time_gar4
archetype BOOK2SND
volume -300 // to talk over Karras babble
delay 25000
time_gar4

// "Hmmm... Looks like Alisha is still alive."
schema time_gar5
archetype BOOK2SND
volume -400
delay 1500
time_gar5

// "Looks like Id better find someone whos planning to leave tonight..."
schema time_gar6
archetype BOOK2SND
volume -400
delay 1500
time_gar6

// "...nice sermon ... except that Im carrying a certain doll..."
schema time_gar7
archetype BOOK2SND
volume -400
delay 1500
time_gar7

// "Hmmm... Looks like Alisha is still alive..."
schema time_gar8
archetype BOOK2SND
volume -400
time_gar8

// "Ah... Looks like Alisha -really is- alive...
// Alternate version if player reads Cavador's to-do list first.
schema time_gar8a
archetype BOOK2SND
volume -400
time_gar8a

// "So this night when Alisha picked up my new eye."
schema time_gar9
archetype BOOK2SND
volume -400
time_gar9

// "I wonder if Counselor Franticius is working late tonight..."
schema time_gar10
archetype BOOK2SND
volume -350
time_gar10

// "All I have to do is follow her until she meets up with Franticius"
// --Removed for simplicity--
// schema time_gar11
// archetype BOOK2SND
// volume -300
// time_gar11

// "Hmmm, this should be interesting..."
// No sensible place to trigger this in a quiet spot.
// schema time_gar12
// archetype BOOK2SND
// volume -300
// delay 1500
// time_gar12

// "Wasn't supposed to be a holy war..."
schema time_gar13
archetype BOOK2SND
volume -400
delay 1500
time_gar13


////////// REVERSING THE ORDER -- Garrett VOs /////////

// "I wonder what this was all about?" [not used]
schema rev_gar1
archetype BOOK2SND
volume -400
rev_gar1

// "I dont like the looks of this. Better keep close."
schema rev_gar2
archetype BOOK2SND
delay 1000
volume -400 // as of 1-15-05 (was -200)
rev_gar2

// "They really are going to kill her. BUT NOT IF I CAN HELP IT!"
schema rev_gar3
archetype BOOK2SND
volume -300
rev_gar3

// "Looks like good ol Pinchenden has his boys out in force tonight."
schema rev_gar4
archetype BOOK2SND
volume -300
delay 1500
rev_gar4

// "Better watch my back... these guys are everywhere."
schema rev_gar5
archetype BOOK2SND
volume -300
delay 1500
rev_gar5

// "Alisha has to be heading for the Old Village..."
schema rev_gar6
archetype BOOK2SND
volume -300
delay 1500
rev_gar6

// "I think I liked it better when I was having Hallucinations!"
schema rev_gar7
archetype BOOK2SND
volume -300
delay 1500
rev_gar7

// "Okay Garrett, calm down. Lets take this one step at a time."
schema rev_gar8
archetype BOOK2SND
volume -300
delay 1500
rev_gar8

// "Damn! This is nuts! How many guys did Pichenden hire anyhow?"
schema rev_gar9
archetype BOOK2SND
volume -300
delay 1500
rev_gar9

// "Damn! This isnt working!" [not used]
schema rev_gar10
archetype BOOK2SND
volume -300
delay 1500
rev_gar10

// "Ahhh KEVELs House! I dont suppose the Missies will mind..."
schema rev_gar11
archetype BOOK2SND
volume -400 //  1-15-05 (was -250)
delay 500
rev_gar11

// "This is where Franticius killed her the last time..."
schema rev_gar12
archetype BOOK2SND
volume -200 // 1-22-05 (was -200)
delay 1500
rev_gar12

// "What the hell? Whos taking those shots?"
schema rev_gar13
archetype BOOK2SND
volume -200 // 1-21-05 (was -200)
rev_gar13

// Random sayings rev_gar4-9
schema rev_gar14
archetype BOOK2SND
volume -300
delay 1500
no_repeat
rev_gar4 rev_gar5 rev_gar6 rev_gar7 rev_gar8 rev_gar9